<?php

    $tdl_options = woodstock_global_var();
    $blog_with_sidebar = "";
    if ( (isset($tdl_options['tdl_single_blog_layout'])) && ($tdl_options['tdl_single_blog_layout'] == "1" ) ) $blog_with_sidebar = "yes";
    if (isset($_GET["blog_with_sidebar"])) $blog_with_sidebar = $_GET["blog_with_sidebar"];  

?>

<section class="no-results not-found">
	
	<div class="row">
	
	<?php if ( $blog_with_sidebar != "yes" ) :  ?>
		<div class="large-8 large-centered text-center columns without-sidebar">
	<?php endif; ?>	
	
		<header class="page-header">
			<h1 class="page-title"><?php esc_html_e( 'Nada Encontrado', 'woodstock' ); ?></h1>
		</header><!-- .page-header -->
	
		<div class="page-content">
			<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
	
				<p><?php printf( esc_html__( 'Pronto para publicar seu primeiro post? <a href="%1$s">Get started here</a>.', 'woodstock' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>
	
			<?php elseif ( is_search() ) : ?>
	
				<p><?php esc_html_e( 'Desculpe, mas nada foi encontrado com o termo pesquisado. Por favor, tente novamente com outros termos.', 'woodstock' ); ?></p>
				<?php get_search_form(); ?>
	
			<?php else : ?>
	
				<p><?php esc_html_e( 'Parece que nós não conseguimos encontrar o que você está procurando.', 'woodstock' ); ?></p>
				<?php get_search_form(); ?>
	
			<?php endif; ?>
		</div><!-- .page-content -->
		
	</div><!--.large-8-->
	
	<?php if ( $blog_with_sidebar != "yes" ) : ?>
		</div>
	<?php endif; ?>	
		
</section><!-- .no-results -->
